﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class MainForm


    Private Sub cmdConstructors_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdConstructors.Click

        '构造函数是实例化类时
        '执行的代码。构造函数可能需要
        '传入参数，也可能不需要。

        '下面的语法在一行中使用构造函数
        '实例化类。这是使用构造函数
        '实例化类的推荐方法：

        Dim cust As New CustomerWithConstructor("1101", "Dale", "Sleppy")

        '此外，可以在创建变量后实例化
        '类：

        Dim cust2 As CustomerWithConstructor
        cust2 = New CustomerWithConstructor("1101", "Dale", "Sleppy")

        '如果需要，可在类中重载 Sub New 过程。
        '这样，可以创建从不同客户端代码
        '调用的不同版本的构造函数。
        '例如，您可能需要一个可从外部代码调用的
        '构造函数，在这种情况下，可以使用 Public Overloads Sub
        ' New()。然后，您可能希望添加一个单独构造函数，该函数只能
        '从类中的代码调用（例如，如果要
        '实现 Clone 方法）。在这种情况下，可以使用
        'Private Overloads Sub New()。
        '
        '在 VB.NET 中使用构造函数可做的另一件事是执行
        '类的访问控制。例如，假定您希望
        '开发一个向外部代码公开的类，但不能直接
        '创建。您可以创建一个公共类并向
        '声明为 Friend 的类添加构造函数。

    End Sub

    Private Sub cmdOverloads_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdOverloads.Click
        Dim myCust1 As Customer
        Dim myCust2 As Customer

        '“Overloads”关键字的用途是允许
        '创建具有相同名称但执行不同代码的
        '多个过程。
        '
        '假定您希望创建一种从数据库或集合中
        '查找客户的方法。您还希望能够
        '按照姓氏或客户的 ID 编号查找
        '客户。
        '
        '可以使用 Overloads 关键字创建两个同名
        '函数。每个版本的函数可以有不同的
        '参数集。
        '
        '调用重载的过程时，将看到通过
        'Intellisense 可用的不同版本。在
        'Intellisense 消息的开头，您将看到带有指示器的向上和向下
        '箭头，显示存在多少个重载版本的
        '过程，当前正在查看的是哪个版本。
        '
        '可以更改下面的参数以
        '查看重载过程的 Intellisense 示例。将光标置于
        '第二个 GetCustomer 调用中的数字 1101 之后，按
        '空格键。

        myCust1 = GetCustomer("Sleppy")
        myCust2 = GetCustomer(1101)

        '向下滚动到下面的 GetCustomer 过程，查看如何
        '实现 Overloads 关键字。

    End Sub

    Private Sub cmdParamProperties_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdParamProperties.Click

        Dim cust As New CustomerWithParameterizedProperty()

        '要创建参数化属性，可以将参数添加到
        'Property 语句。有关
        '详细信息，请参见 CustomerWithParameterizedProperty.DefaultQuantity。
        '
        '参数可以是任意类型，但作为索引使用时通常
        '是 integer。
        '
        '下面您将看到，实现参数化属性时，
        '必须指定参数，即使属性过程
        '不使用该参数（如本例）。我们设置属性
        '过程将参数作为客户默认数量的
        '乘数。如果您传递 5，则将客户的
        '默认数量乘以 5。
        '
        '设置 DefaultQuantity 值时，即使不使用
        '乘数参数，也必须传入该参数。


        cust.DefaultQuantity(0) = 100

        MessageBox.Show("The default quantity for this customer is " & cust.DefaultQuantity(3) & ".", Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)


    End Sub

    Private Sub cmdPropertySyntax_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdPropertySyntax.Click

        '下面的代码创建
        'CustomerPropertySyntax 类的实例，并在只读属性
        'AccountNumber 中检索值。有关
        '属性语法的详细信息，请单步执行代码。

        Dim myAccount As String
        Dim cust As New CustomerPropertySyntax("1101")

        myAccount = cust.AccountNumber

    End Sub

    Private Sub cmdSharedMembers_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdSharedMembers.Click

        '一个类中有两个主类型的共享成员。
        '第一个类型是共享变量，第二个类型是
        '共享过程。
        '
        '下面我们创建 customer 类的两个实例，
        '并更改共享变量“CompanyName”。运行
        '此代码时，应看到一条消息，说明
        '公司名称为 Tailspin Toys。这段代码说明
        '更改该类的任何实例的变量
        '实际上将更改所有实例中该变量的值。

        Dim cust1 As New CustomerWithSharedMembers()
        Dim cust2 As New CustomerWithSharedMembers()

        '可按如下方式使用标准对象语法：
        CustomerWithSharedMembers.CompanyName = "Wingtip Toys"
        CustomerWithSharedMembers.CompanyName = "Tailspin Toys"
        MessageBox.Show("The company name is " & CustomerWithSharedMembers.CompanyName & ".", Me.Text)

        '下一个共享成员类型是共享过程。
        MessageBox.Show("The last order was placed on " & _
            CustomerWithSharedMembers.LastOrderDate & ".", Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
    End Sub

    Private Overloads Function GetCustomer(ByVal CustID As Integer) As Customer
        '这是一个传入整数时调用的函数。
        Dim cust As New Customer()

        '通常使用 CustID 整数在
        '数据库或集合中搜索客户的 ID 编号。
        '这里我们只准备向 Customer 对象填充一些
        '假数据。
        cust.AccountNumber = "1101"
        cust.FirstName = "Dale"
        cust.LastName = "Sleppy"

        Return cust
    End Function

    Private Overloads Function GetCustomer(ByVal CustLastName As String) As Customer
        '这是一个在传入字符串时调用的函数。
        Dim cust As New Customer()
        '通常使用 CustLastName 字符串在
        '数据库或集合中搜索客户的姓氏。
        '这里我们只准备向 Customer 对象填充一些
        '假数据。
        cust.AccountNumber = "1101"
        cust.FirstName = "Dale"
        cust.LastName = "Sleppy"

        Return cust

    End Function



    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
